<?php

namespace App\Models\Students;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Student extends Model 
{

    protected $table = 'students';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getAttendances()
    {
        return $this->hasMany('Attandance');
    }

    public function getKeywords()
    {
        return $this->belongsToMany('Keyword', 'att_keyword', 'student_id', 'keyword_id');
    }

    public function getGroups()
    {
        return $this->belongsToMany('Group', 'student_group');
    }

    public function getOwnedGroups()
    {
        return $this->hasMany('Group', 'owner_student_id');
    }

}